# Pytheia v1.1.0 — Client Instructions (Advanced Package)

## Overview
Pytheia is a telescope pointing model framework developed by Orionis Group.  
This package is licensed software — users may only modify `config.py`.

v1.1.0 extends the baseline v1.0.0 with:
- Editable pointing model terms via `config.py`
- Integrity guard with Ed25519 signatures
- Local-time stamping in HTML reports
- Improved Windows console color handling
- CycloneDX SBOM and exact `requirements.txt` for reproducibility
- **Simplified outputs**: only a single self-contained HTML report per run

---

## License and Integrity
- **License enforcement**: via `pytheia_license.json` (signed, expires Oct 18 2025).  
- **Integrity enforcement**: `INTEGRITY.json` + `INTEGRITY.sig` validated at runtime.  
- **Guard**: `pytheia_guard.py` blocks tampering.  
- **Trial/expiry**: execution stops if license is invalid or expired.  

---

## Installation
1. Ensure Python 3.10+ is installed.  
2. Install dependencies:  
   ```bash
   pip install -r requirements.txt
   ```
   The `requirements.txt` and `sbom.cyclonedx.json` lock exact dependency versions.  
3. Place the package contents in a writable directory.  

Optional: verify package integrity:  
```bash
python validate_integrity.py
```

---

## Files in This Package
- **Pytheia100_main.py** — Entry point. Runs integrity + license checks, loads config, audits runs.  
- **Pytheia100_core.py** — Core engine (fit, plots, report). Cannot be run directly.  
- **config.py** — User-editable. Set input data, terms, mode, latitude, auxiliaries, and optionally override `pointing_model()`.  
- **pytheia_guard.py** — License & integrity enforcement.  
- **INTEGRITY.json / INTEGRITY.sig** — Integrity manifest + signature.  
- **pytheia_license.json** — Signed license file (v1.1.0).  
- **pytheia_public_key.pem** — Public key for verification.  
- **requirements.txt** — Dependency list.  
- **sbom.cyclonedx.json** — CycloneDX SBOM (supply chain transparency).  
- **Sample data** — Example dataset for test runs.  
- **README_CLIENT_v1.1.0.md** — This document.  

---

## Editing `config.py`
You may adjust:
- `input_dat` — path to your dataset (4-column ASCII).  
- `selected_terms` — pointing terms to fit.  
- `latitude` — observatory latitude (radians).  
- `mode` — `"azel"` or `"hadec"`.  
- `aux1`, `aux2` — optional auxiliary arrays/scalars.  
- **Custom model** — Advanced users may redefine `pointing_model()` to extend terms.  

Only `config.py` is meant to be user-edited. Do not modify other files.

---

## How to Run
From the package directory:
```bash
python Pytheia100_main.py
```

Optional arguments:
```bash
python Pytheia100_main.py path/to/data.dat
```

Environment variable alternative:
```bash
set PYTHEIA_DATA=path/to/data.dat   # Windows PowerShell: $env:PYTHEIA_DATA="..."
```

Results are written into a unique subdirectory under `My_Pointing_model_results/`.

---

## Outputs Produced (v1.1.0)
Each run produces:
- **`combined_results_bayesian.html`** — A self-contained HTML report (plots, fitted parameters, correlation matrix, footer). Saved in a unique `terms_xxxxx` subdirectory.  
- **`pytheia_audit.jsonl`** — Append-only JSONL audit log of runs (written at package root).  

📌 All content is embedded inside the HTML.

---

## Interpreting the output

When a run completes, review the HTML report.

### Summary metrics
- **Fit RMS**: ΔAz/ΔEl (or ΔHA/ΔDec) and total RMS [arcsec].  
  Typical: <5–10″. Higher = potential issue.  
- **Noise (α)** & **Regularization (λ)**: Estimated by Bayesian Ridge. λ/α ratio indicates model complexity vs. data fidelity.  

### Diagnostic plots
- **Sky coverage** — dataset span; poor coverage biases the fit.  
- **Raw vs corrected residuals** — corrected should be centered & pattern-free.  
- **Histograms** — should approximate Gaussian.  
- **Parameter magnitude vs σ** — large |value| & small σ = well-constrained; weak terms = candidates to drop.  
- **Log-marginal likelihood** — tuning convergence indicator.  

### Fitted parameters
- Listed inside the HTML report as value ±1σ [arcsec].  
- Terms with |value| ≲ σ are weak.  

### Correlation matrix
- Shown in the HTML. High |corr| (>0.8) between terms signals redundancy.  
- Prefer interpretable terms or collect more diverse data.  

### When RMS is high
- Recheck selected terms in `config.py`.  
- Confirm mode, latitude, and input format.  
- Review correlation matrix & residual plots for unmodeled trends.  

### Quick Reference — Output Cheat Sheet

| Element                          | Meaning                                            | Good Range / Notes                                      |
|----------------------------------|----------------------------------------------------|---------------------------------------------------------|
| **Fit RMS ΔAz / ΔEl / Total**    | Residual pointing error in arcseconds              | Typically <5–10″ (higher = possible issue)              |
| **Noise (α)**                    | Estimated data noise level                         | Higher α → cleaner data; very low α = noisy measurements|
| **Regularization (λ)**           | Shrinkage toward simpler model                     | High λ shrinks coefficients; balance with α             |
| **Residual plots**               | Raw vs corrected pointing errors                   | Corrected residuals centered & pattern-free             |
| **Histograms**                   | Distribution of residuals                          | Should look roughly Gaussian                            |
| **Parameter ± σ**                | Fitted term value with 1σ uncertainty              | Large |value| with small σ = well-constrained            |
| **Correlation matrix (|corr|)**  | Linear dependency between terms                    | |corr| >0.8 → redundancy; consider pruning or more data  |
| **Log-marginal likelihood**      | Bayesian model evidence during tuning              | Stable plateau = good convergence                       |

---

## Troubleshooting
- **Integrity check failed** → file tampered or mismatch with manifest. Reinstall package.  
- **Trial expired / license invalid** → license expired or invalid. Contact support@orionisgroup.com.  
- **Unknown term error** → invalid term in `selected_terms` or custom `pointing_model()`.  
- **Report missing** → check data path and config; the HTML report is always generated if run completes.  
- **Audit log not written** → check write permissions in package root.  

---

## Support
Orionis Group Company  
Princeton, NJ USA  
support@orionisgroup.com  

---
