# Release Notes — Pytheia v1.1.0

**Release date:** September 2025  
**Product:** Pytheia100 v1.1.0  
**Publisher:** Orionis Group

---

## Highlights
- **Editable pointing model terms** via `config.py` (user can add/remove terms).
- **Integrity & licensing guard** enforced with Ed25519 signatures.
- **Local-time stamping** in HTML report footer.
- **Improved Windows console colors** (fitted parameters + success messages).
- **CycloneDX SBOM** and exact `requirements.txt` included for reproducibility.
- **Simplified outputs**: now only a single self-contained HTML report per run, plus an audit log.

---

## Files Added/Updated
- `README_CLIENT_v1.1.0.md` — updated to reflect simplified outputs.
- `config.py` — supports editable pointing model; consistent with `core`.
- `Pytheia100_main.py` — improved guard, integrity injection, and clearer outputs.
- `Pytheia100_core.py` — updated reporting, footer injection, console outputs.
- `sbom.cyclonedx.json` — new supply chain manifest.
- `requirements.txt` — exact locked dependencies.

---

## Compatibility
- Requires **Python 3.10+**.
- Runs on Windows (PowerShell-friendly console output) and Linux.
- Data format: ASCII file with 4 whitespace-separated columns.

---

## Upgrade Notes
- Users of v1.0.0 can migrate directly.  
- Copy your data files and adjust `config.py` terms.  
- New license file (`pytheia_license.json`) required for v1.1.0.  
- Note: Outputs are simplified in v1.1.0 (HTML + audit only).  

---

## Known Issues
- Poor dataset coverage still leads to degeneracies (as expected).  
- Ensure consistent units (radians) in input data.  

---
