# Pytheia100 v1.1.0 — Release Notes

**Release date:** September 2025  
**Edition:** Client Gold — with Integrity & License Guard

---

## Overview

Pytheia100 v1.1.0 builds on the v1.0.0 Gold package with important enhancements for flexibility, integrity, and usability. This release introduces *editable pointing terms* via `config.py`, stronger integrity verification, and improved user experience on Windows/PowerShell.

---

## What’s New

### 1. Configurable Pointing Model
- Clients can now define or override the `pointing_model` function inside `config.py`.
- Built-in pointing terms are still available; custom term sets allow site-specific calibration.
- Validation helpers ensure correct shape and catch misconfigured models.

### 2. Enhanced Integrity & Guard
- Core is guarded and cannot be executed directly.
- Main injects `org_name`, `version_string`, and **local timestamp** into the core before execution.
- Integrity manifest verifies **main** against a signed Ed25519 hash.

### 3. Improved License Handling
- License checked at startup via Ed25519 signature.
- Expiry and seat lock enforced by Guard.
- Near-expiry warnings (7 days by default).

### 4. Windows / PowerShell Output
- ANSI color handling improved with VT mode + `colorama`.
- Optional **monochrome mode** (`set PYTHEIA_COLOR=never`) avoids low-contrast colored lines.

### 5. Report Footer
- Report HTML (`combined_results_bayesian.html`) now shows:
  - Version (v1.1.0)
  - Local timestamp (with system’s timezone)
  - Licensed organization

---

## Fixed / Improved from v1.0.0
- Footer timestamp is now local system time.
- No more accidental passing of `mode` argument to custom pointing model.
- Clearer audit logs with corrected timestamp formatting.
- Dependencies clarified (`termcolor` instead of `colored`, `colorama` added).

---

## Known Limitations
- Integrity manifest is scoped only to Main (not full package).
- License must be regenerated for each version; old licenses will not validate.
- PowerShell color rendering still depends on theme; monochrome toggle recommended if output is unreadable.
- Report correlation table does not highlight significance thresholds.

---

## Upgrade Notes
- If you used v1.0.0:
  - Replace the old package with this bundle.
  - Update your `config.py` if you want to use editable pointing models.

---

## Support
Orionis Group Company — Princeton, NJ, USA  
Email: support@orionisgroup.com
